package kochModel.visitor;

import lrs.*;
import kochModel.*;
import fp.*;

public class CountVisitor implements IKochVisitor<Integer, Object> {
  
  public static final CountVisitor Singleton = new CountVisitor();
  
  private CountVisitor() {}

  public Integer baseCase(Koch host, Object... param) {
    return 1;
  }
  
  public Integer inductCase(Koch host, Object... param) {
    final int[] count = new int[1];
    host.map(new IMapAlgo<Koch, Object>() {
      public boolean apply(Koch host, Object... inp) {
        count[0] += host.execute(CountVisitor.this);
        return true;
      }
      public void noApply(Object... inp) {
      }
    });
    return count[0];
  }
}